var commentAreas = [];

// 保存备注

function doSaveComment(mailid, content) {
	try {
		invokeAppFunction('SetMailComment', {
			mailid: mailid,
			content: content
		});
	} catch (e) {
		writelog('doSaveComment', e.message);
	}
}

// 显示添加备注

function doShowCommentEditer(mailid, content, readOnly) {
	try {
		// 每次都查看一下是否加载
		var isLoad = $("#ph_comment_" + mailid);
		if (isLoad !== "true") {
			var com = new FoxUI.TextArea({
				id: 'ph_comment_' + mailid,
				defaultVisible: false,
				content: content,
				record: {
					mailid: mailid
				},
				doSave: function() {
					var content = this.getContent();
					doSaveComment(this.record.mailid, content);
					this.hide(function() {
						adjustMailFrameSize();
						adjustExpandMailContentSize(true);
						updateComment(mailid, false);
					});
				}
			});
			com.render();
			$("#ph_comment_" + mailid).attr("isLoad", "true");
			commentAreas[mailid] = com;
		}
		commentAreas[mailid].show(function() {
			adjustMailFrameSize();
			adjustExpandMailContentSize(true);
		});
	} catch (e) {
		writelog('doShowCommentEditer', e.message);
	}
}

// 隐藏添加备注

function doHideComment(mailid) {
	try {
		var el = $('#ph_comment_show_' + mailid);
		el.animate({
			height: 'hide'
		}, 300, 'swing', function() {
			adjustMailFrameSize();
			adjustExpandMailContentSize(true);
		});
	} catch (e) {
		writelog('doHideComment', e.message);
	}
}

// 删除备注

function doDeleteComment(mailid) {

}

// 更新备注

function updateComment(mailid, isLoad) {
	try {

		var comment = invokeAppFunction('GetMailComment', {
			mailid: mailid
		});

		var id = '#ph_comment_show_' + mailid;
		var el = $(id);
		if (comment !== '') {
			el.find('.content').html(comment);
			if (isLoad) {
				el.css('display', '');
			} else {
				el.animate({
					height: 'show'
				}, 300, 'swing', function() {
					adjustMailFrameSize();
					adjustExpandMailContentSize(true);
				});
			}

		} else {
			el.css('display', 'none');
		}
	} catch (e) {
		writelog('updateComment', e.message);
	}
}